using System;
using System.Text;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class Service : System.Web.Services.WebService
{
   public Service()
   {

      // Uncomment the following line if using designed components 
      // InitializeComponent();
   }

   [WebMethod]
   public string HelloWorld()
   {
      return "Witaj wiecie";
   }

   [WebMethod(Description =
     "czy dwa acuchy znakowe, zwraca wynik konkatenacji oraz dugo acucha wynikowego.")]
   public int StringConcat(string string1, string string2, out string stringTotal)
   {
      StringBuilder sb = new StringBuilder();
      sb.Append(string1);
      sb.Append(string2);
      stringTotal = sb.ToString();
      return stringTotal.Length;
   }

   [WebMethod(Description = "Przelewa kwot pienin pomidzy kontami.",
      TransactionOption = System.EnterpriseServices.TransactionOption.Required)]
   public void Transfer(string sourceAccount, string destAccount, decimal amount)
   {
      // przelej kwot 'amount' z konta 'sourceAcount' na konto 'destAccount'
   }

   [WebMethod(Description = "Zasiga informacji dotyczcych salda okrelonego rachunku bankowego.")]
   public decimal Inquiry(string account)
   {
      return 0.0m;
   }

   [WebMethod(Description = "Deponuje kwot pienin na podanym rachunku.",
     TransactionOption = System.EnterpriseServices.TransactionOption.Required)]
   public void Deposit(string destAccount, decimal amount)
   {
      // deponuje kwot 'amount' na konto 'destAccount'
   }

   [WebMethod(Description = "Ustawia warto zmiennej stanu sesji", EnableSession = true)]
   public void SetSessionVariable(string variable, string value)
   {
      Session[variable] = value;
   }

   [WebMethod(Description = "Pobiera warto zmiennej stanu sesji", EnableSession = true)]
   public string QuerySessionVariable(string variable)
   {
      return (string)Session[variable];
   }

   [WebMethod(Description = "Ustawia warto zmiennej o zasigu dla caej aplikacji")]
   public void SetAppVariable(string variable, string value)
   {
      Application[variable] = value;
   }

   [WebMethod(Description = "Pobiera warto zmiennej o zasigu dla caej aplikacji")]
   public string GetAppVariable(string variable)
{
   return (string)Application[variable];
}


}

